<?php
require_once(ABSPATH . 'wp-admin/includes/media.php');
require_once(ABSPATH . 'wp-admin/includes/file.php');
require_once(ABSPATH . 'wp-admin/includes/image.php');
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * HELPER COMMENT START
 * 
 * This class is used to bring your plugin to life. 
 * All the other registered classed bring features which are
 * controlled and managed by this class.
 * 
 * Within the add_hooks() function, you can register all of 
 * your WordPress related actions and filters as followed:
 * 
 * add_action( 'my_action_hook_to_call', array( $this, 'the_action_hook_callback', 10, 1 ) );
 * or
 * add_filter( 'my_filter_hook_to_call', array( $this, 'the_filter_hook_callback', 10, 1 ) );
 * or
 * add_shortcode( 'my_shortcode_tag', array( $this, 'the_shortcode_callback', 10 ) );
 * 
 * Once added, you can create the callback function, within this class, as followed: 
 * 
 * public function the_action_hook_callback( $some_variable ){}
 * or
 * public function the_filter_hook_callback( $some_variable ){}
 * or
 * public function the_shortcode_callback( $attributes = array(), $content = '' ){}
 * 
 * 
 * HELPER COMMENT END
 */

/**
 * Class Frontend_Qr_Code_Generator_Run
 *
 * Thats where we bring the plugin to life
 *
 * @package		FRONTENDQR
 * @subpackage	Classes/Frontend_Qr_Code_Generator_Run
 * @author		Benjermin Pinales
 * @since		1.0.0
 */
class Frontend_Qr_Code_Generator_Run{

	/**
	 * Frontend_Qr_Code_Generator_Run constructor 
	 * to run the plugin logic.
	 *
	 * @since 1.0.0
	 */
	function __construct(){
		$this->add_hooks();
	}

	

	/**
	 * Registers all WordPress and plugin related hooks
	 *
	 * @access	private
	 * @since	1.0.0
	 * @return	void
	 */
	private function add_hooks(){
		add_shortcode( 'fqcg_form', array( $this, 'fqcg_display_form') );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_backend_scripts_and_styles' ), 20 );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_backend_scripts_and_styles' ), 20 );
		add_action('init', array($this, 'enqueue_frontend_scripts_and_styles'), 20);
	}

	/**
	 * ######################
	 * ###
	 * #### WORDPRESS HOOK CALLBACKS
	 * ###
	 * ######################
	 */

	/**
	 * Enqueue the backend related scripts and styles for this plugin.
	 * All of the added scripts andstyles will be available on every page within the backend.
	 *
	 * @access	public
	 * @since	1.0.0
	 *
	 * @return	void
	 */
	public function enqueue_backend_scripts_and_styles() {
		wp_enqueue_style( 'frontendqr-backend-styles', FRONTENDQR_PLUGIN_URL . 'core/includes/assets/css/backend-styles.css', array(), FRONTENDQR_VERSION, 'all' );
		wp_enqueue_script( 'frontendqr-backend-scripts', FRONTENDQR_PLUGIN_URL . 'core/includes/assets/js/backend-scripts.js', array(), FRONTENDQR_VERSION, false );
		wp_localize_script( 'frontendqr-backend-scripts', 'frontendqr', array(
			'plugin_name'   	=> __( FRONTENDQR_NAME, 'frontend-qr-code-generator' ),
		));
	}
	public function enqueue_frontend_scripts_and_styles() {
		wp_enqueue_style( 'fqcg-frontend-styles', FRONTENDQR_PLUGIN_URL . 'core/includes/assets/css/frontend-styles.css', array(), FRONTENDQR_VERSION, 'all' );
		wp_enqueue_script( 'frontendqr-frontend-scripts', FRONTENDQR_PLUGIN_URL . 'core/includes/assets/js/frontend-scripts.js', array(), FRONTENDQR_VERSION, false );
		wp_localize_script( 'frontendqr-frontend-scripts', 'fqcgAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));  
		wp_localize_script( 'frontendqr-fontend-scripts', 'frontendqr', array(
			'plugin_name'   	=> __( FRONTENDQR_NAME, 'frontend-qr-code-generator' ),
		));
		      

   wp_enqueue_script( 'jquery' );
   wp_enqueue_script( 'fqcg_remove_img' );
	}
	
	public static function fqcg_display_form(){
		echo "<div class='fqcg-form-wrap fqcg-flex-row'>";
		
		$fqcg_nonce = wp_create_nonce('fqcg_secure');
		echo "<form action='#' id='fqcg-form' class='fqcg-flex-column'>";
		echo "<label for='textToChange' >Generate</label>";
		echo "<input name='textToChange' type='text' required>";
		echo "<label for='qrSize'>Image Size</label>";
		echo "<input name='qrSize' type='number' max='1000' min='50' value='80'>";
		echo "<input name='gibberish' type='hidden' value='".$fqcg_nonce."'>";
		echo "<button type='submit'>submit</button>";
		echo "</form>";
		
		echo "<div class='fqcg-res fqcg-flex-column'>";
		if($_REQUEST['gibberish']){
			$bpSanText = sanitize_text_field( $_REQUEST['textToChange'] );
			$bpSanS = sanitize_text_field( $_REQUEST['qrSize']);
			
			fqcg_get_code($bpSanText, $bpSanS);
			
		}else{
			echo "<div style='width: 80px; height: 80px; background: rgb(150, 150, 150);'> </div>";
		}
		echo "</div></div>";
	}
	
	

}



// function fqcg_qr(){
// 	$url = 'http://api.qrserver.com/v1/create-qr-code/?data=HelloWorld!&size=100x100';
// 	$img = FRONTENDQR_PLUGIN_URL.'core/includes/assets/img/placeholder.jpg';
// 	file_put_contents($img, file_get_contents($url));
// 	echo "<img src='".$img."'>";
// }
function fqcg_get_code($req, $size){
		$fqcg_qr_url = "https://api.qrserver.com/v1/create-qr-code/?data=".$req."&size=".$size."x".$size;
		//  http://api.qrserver.com/v1/create-qr-code/?data=HelloWorld!&size=100x100
		$fqcg_curl = curl_init();
	$orReq = $req;
	if(str_contains($req, '/') || str_contains($req, '.') || str_contains($req, 'https://') || str_contains($req, 'http://') || str_contains($req, 'www')){
				$qrGent4 = str_replace( array( '\'', '"',
      ',' , ';', '<', '>', 'https://', 'http://', '/', 'www.' ), '', $req);
				$qrGent5 = str_replace('.', '-' ,$qrGent4);
				$req = $qrGent5;
			}
		curl_setopt_array($fqcg_curl, array(
		  CURLOPT_URL => $fqcg_qr_url,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'GET',
		  CURLOPT_HTTPHEADER => array('Content-Type: text/plain')
		));

		$fqcg_response = curl_exec($fqcg_curl);
		curl_close($fqcg_curl);
	
		$imgCheck = get_attachment_url_by_slug("user-qr");
		if($imgCheck){
			wp_delete_attachment($imgCheck, true);
		}
	
	    $mediaImageId = media_sideload_image($fqcg_qr_url.".jpg", 0, "user-qr", "id");
		$mediaURL = wp_get_attachment_image_url($mediaImageId);
		$fqcg_nonce = wp_create_nonce('fqcg_secure');
		echo "<iframe id='fqcg-iframe' title='qr-code' src='".$fqcg_qr_url."' width='".$size."' height='".$size."'></iframe>";
		echo "<p>".$orReq."</p>";
		echo "<a target='_blank' href='".$mediaURL."' download='".$req."'><button data-gibberish='".$fqcg_nonce."' data-id='".$mediaImageId."' onclick='fqcgDelImg(this)'>Download</button></a>";
	
}


add_action("wp_ajax_fqcg_remove_img", "fqcg_get_qr_code");
function fqcg_get_qr_code(){
	if ( !wp_verify_nonce( $_REQUEST['gibberish'], "fqcg_secure")) {
      exit("No naughty business please!!!");
   }else{
		wp_delete_attachment($_REQUEST['id'], true);
	}

}

function get_attachment_url_by_slug( $slug ) {
  $args = array(
    'post_type' => 'attachment',
    'name' => sanitize_title($slug),
    'post_status' => 'inherit',
  );
  $_header = get_posts( $args );
  $header = $_header ? array_pop($_header) : null;
  return $header ? $header->ID : false;
}








