<?php
/**
 * Frontend QR Code Generator
 *
 * @package       FRONTENDQR
 * @author        Benjermin Pinales
 * @license       gplv2
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   Frontend QR Code Generator
 * Plugin URI:    benjerminp.opalstacked.com/plugins
 * Description:   This plugin allows users to generate QR-Codes on your site. It is a great way to add something your users can take away from your site for free.
 * Version:       1.0.0
 * Author:        Benjermin Pinales
 * Author URI:    benjerminp.opalstacked.com/plugins
 * Text Domain:   frontend-qr-code-generator
 * Domain Path:   /languages
 * License:       GPLv2
 * License URI:   https://www.gnu.org/licenses/gpl-2.0.html
 *
 * You should have received a copy of the GNU General Public License
 * along with Frontend QR Code Generator. If not, see <https://www.gnu.org/licenses/gpl-2.0.html/>.
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function FRONTENDQR() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define( 'FRONTENDQR_NAME',			'Frontend QR Code Generator' );

// Plugin version
define( 'FRONTENDQR_VERSION',		'1.0.0' );

// Plugin Root File
define( 'FRONTENDQR_PLUGIN_FILE',	__FILE__ );

// Plugin base
define( 'FRONTENDQR_PLUGIN_BASE',	plugin_basename( FRONTENDQR_PLUGIN_FILE ) );

// Plugin Folder Path
define( 'FRONTENDQR_PLUGIN_DIR',	plugin_dir_path( FRONTENDQR_PLUGIN_FILE ) );

// Plugin Folder URL
define( 'FRONTENDQR_PLUGIN_URL',	plugin_dir_url( FRONTENDQR_PLUGIN_FILE ) );

/**
 * Load the main class for the core functionality
 */
require_once FRONTENDQR_PLUGIN_DIR . 'core/class-frontend-qr-code-generator.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  Benjermin Pinales
 * @since   1.0.0
 * @return  object|Frontend_Qr_Code_Generator
 */
function FRONTENDQR() {
	return Frontend_Qr_Code_Generator::instance();
}
FRONTENDQR();
